﻿//////////////////////////////////////////////
// EnvironmentManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkScripts
#include "../Dll/DllDefines.h"

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT EnvironmentManager final : public nkCommon::SingletonClass<EnvironmentManager>
	{
		public :

			// Memory management
			Environment* createOrRetrieve (nkMemory::StringView name) ;
			Environment* get (nkMemory::StringView name) ;
			Environment* getByIndex (unsigned int id) ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;

		private :

			// Attributes
			std::unordered_map<std::string, nkMemory::UniquePtr<Environment>> _memory ;

		private :

			// Functions
			// Constructor, destructor
			EnvironmentManager () noexcept ;
			EnvironmentManager (const EnvironmentManager&) = delete ;
			virtual ~EnvironmentManager () ;

			// Operators
			EnvironmentManager& operator= (const EnvironmentManager&) = delete ;

		private :

			friend class nkCommon::SingletonClass<EnvironmentManager> ;
	} ;
}

